/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.merequester.requester.abstraction;

import appeng.api.inventories.InternalInventory;
import appeng.api.networking.IGrid;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.helpers.InventoryAction;
import appeng.menu.AEBaseMenu;
import appeng.menu.me.interaction.EmptyingAction;
import appeng.menu.me.interaction.StackInteractions;
import com.almostreliable.merequester.MERequester;
import com.almostreliable.merequester.platform.Platform;
import com.almostreliable.merequester.requester.RequesterBlockEntity;
import com.almostreliable.merequester.requester.Requests;
import com.almostreliable.merequester.requester.abstraction.RequestTracker;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;

public abstract class AbstractRequesterMenu
extends AEBaseMenu {
    public static final String SORT_BY_ID = "sort_by";
    public static final String UNIQUE_NAME_ID = "unique_name";
    private long idSerial = Long.MIN_VALUE;

    protected AbstractRequesterMenu(MenuType<?> menuType, int id, Inventory playerInventory, Object host) {
        super(menuType, id, playerInventory, host);
        this.createPlayerInventorySlots(playerInventory);
    }

    public void doAction(ServerPlayer player, InventoryAction action, int slot, long id) {
        RequestTracker requestTracker = this.getRequestTracker(id);
        if (requestTracker == null) {
            return;
        }
        if (slot < 0 || slot >= requestTracker.getServer().size()) {
            MERequester.LOGGER.warn("Requester Screen refers to invalid slot {} of {}", (Object)slot, (Object)requestTracker.getName());
            return;
        }
        InternalInventory requestSlot = requestTracker.getServer().getSlotInv(slot);
        ItemStack requestStack = requestSlot.getStackInSlot(0);
        ItemStack carriedStack = this.m_142621_();
        switch (action) {
            case PICKUP_OR_SET_DOWN: {
                requestSlot.setItemDirect(0, carriedStack.m_41619_() ? ItemStack.f_41583_ : carriedStack.m_41777_());
                break;
            }
            case SPLIT_OR_PLACE_SINGLE: {
                if (carriedStack.m_41619_()) {
                    requestSlot.setItemDirect(0, ItemStack.f_41583_);
                    break;
                }
                ItemStack copy = carriedStack.m_41777_();
                copy.m_41764_(1);
                requestSlot.setItemDirect(0, copy);
                break;
            }
            case SHIFT_CLICK: {
                requestSlot.setItemDirect(0, ItemStack.f_41583_);
                break;
            }
            case EMPTY_ITEM: {
                EmptyingAction emptyingAction = StackInteractions.getEmptyingAction((ItemStack)carriedStack);
                if (emptyingAction == null) break;
                requestSlot.insertItem(0, GenericStack.wrapInItemStack((AEKey)emptyingAction.what(), (long)emptyingAction.maxAmount()), false);
                break;
            }
            case CREATIVE_DUPLICATE: {
                if (!player.m_150110_().f_35937_ || !carriedStack.m_41619_()) break;
                if (requestStack.m_41619_()) {
                    this.m_142503_(ItemStack.f_41583_);
                    break;
                }
                ItemStack stack = requestStack.m_41777_();
                stack.m_41764_(stack.m_41741_());
                this.m_142503_(stack);
                break;
            }
        }
    }

    public void applyDragAndDrop(ServerPlayer player, int requestIndex, long requesterId, ItemStack item) {
        this.m_142503_(item);
        this.doAction(player, InventoryAction.PICKUP_OR_SET_DOWN, requestIndex, requesterId);
        this.m_142503_(ItemStack.f_41583_);
    }

    public void updateRequesterState(long requesterId, int requestIndex, boolean state) {
        RequestTracker requestTracker = this.getRequestTracker(requesterId);
        if (requestTracker == null) {
            return;
        }
        Requests.Request request = requestTracker.getServer().get(requestIndex);
        request.updateState(state);
    }

    public void updateRequesterNumbers(long requesterId, int requestIndex, long amount, long batch) {
        RequestTracker requestTracker = this.getRequestTracker(requesterId);
        if (requestTracker == null) {
            return;
        }
        Requests.Request request = requestTracker.getServer().get(requestIndex);
        request.updateAmount(amount);
        request.updateBatch(batch);
    }

    protected abstract void sendFullUpdate(@Nullable IGrid var1);

    protected abstract void sendPartialUpdate();

    protected void syncRequestTrackerFull(RequestTracker requestTracker) {
        Requests server = requestTracker.getServer();
        Requests client = requestTracker.getClient();
        CompoundTag tag = server.serialize();
        client.deserialize(tag);
        tag.m_128359_(UNIQUE_NAME_ID, requestTracker.getName());
        tag.m_128356_(SORT_BY_ID, requestTracker.getSortBy());
        Platform.sendInventoryData(this.getPlayer(), requestTracker.getId(), tag);
    }

    protected void syncRequestTrackerPartial(RequestTracker requestTracker) {
        Requests server = requestTracker.getServer();
        Requests client = requestTracker.getClient();
        CompoundTag tag = null;
        for (int i = 0; i < server.size(); ++i) {
            Requests.Request clientRequest;
            Requests.Request serverRequest = server.get(i);
            if (!serverRequest.isDifferent(clientRequest = client.get(i))) continue;
            if (tag == null) {
                tag = new CompoundTag();
                tag.m_128359_(UNIQUE_NAME_ID, requestTracker.getName());
                tag.m_128356_(SORT_BY_ID, requestTracker.getSortBy());
            }
            CompoundTag serverData = serverRequest.serialize();
            tag.m_128365_(String.valueOf(i), (Tag)serverData);
            clientRequest.deserialize(serverData);
        }
        if (tag != null) {
            Platform.sendInventoryData(this.getPlayer(), requestTracker.getId(), tag);
        }
    }

    protected RequestTracker createTracker(RequesterBlockEntity requester) {
        RequestTracker requestTracker = new RequestTracker(requester, this.idSerial);
        ++this.idSerial;
        return requestTracker;
    }

    @Nullable
    protected abstract RequestTracker getRequestTracker(long var1);
}

